
// derive and create a new usermessage.
local CAdmins	=	OOP_Derive( CUserMessage );

// constructor
function CAdmins:__ctor( )
	// hook
	self:HookMessage( "Admin" );
	self:HookMessage( "RemoveAdmin" );
	
	// store admin.
	self.Admins = {};

end

// player has flag?
function CAdmins:HasAccess( pl, flag )
	// superadmins always have access!
	if( pl:IsSuperAdmin() ) then return true; end
	
	// no flag?
	if( !flag || flag == "" ) then return true; end
	
	// found this id?
	local admin = self.Admins[ pl:GetNetworkedString( "steamid" ) ];
	if( !admin ) then return false; end
	
	// has the flag?
	if( string.find( admin.flags, flag ) ) then return true; end
	
	// nothing found
	return false;

end

// player has flag?
function CAdmins:IsAdmin( pl )
	// superadmins always have access!
	if( pl:IsSuperAdmin() ) then return true; end
	
	// found this id?
	local admin = self.Admins[ pl:GetNetworkedString( "steamid" ) ];
	if( !admin ) then return false; end
	
	// true!
	return true;

end

// handler
function CAdmins:OnAdmin( msg )
	// read the flag.
	local name 		= msg:ReadString();
	local steamid 		= msg:ReadString();
	local flags 		= msg:ReadString();
	
	// store
	self.Admins[ steamid ] = {
		name = name,
		steamid = steamid,
		flags = flags,
	};

	// debug
	if( VMFSuite.Debug ) then
		print( "Replicating admin on client = {\n\tname = " .. name .. ",\n\tsteamid = " .. steamid .. ",\n\tflags = " .. flags .. "\n}" );
		
	end
	
end

// handler
function CAdmins:OnRemoveAdmin( msg )
	// read the steamid.
	local steamid 		= msg:ReadString();
	
	// nil it out.
	self.Admins[ steamid ] = nil;
	
end
	
// create
VMFSuite.AdminSystem = CAdmins:create();
